<?php
// Simple admin panel to view KYC applications
session_start();

// Simple authentication (improve this in production)
if (!isset($_SESSION['admin_logged_in'])) {
    if (isset($_POST['username']) && isset($_POST['password'])) {
        // In production, use proper password hashing and database verification
        if ($_POST['username'] === 'admin' && $_POST['password'] === 'admin123') {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $error = 'Invalid credentials';
        }
    }
    
    if (!isset($_SESSION['admin_logged_in'])) {
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <title>KYC Admin Login</title>
            <style>
                body { font-family: Arial, sans-serif; max-width: 400px; margin: 50px auto; padding: 20px; }
                input, button { width: 100%; padding: 10px; margin: 10px 0; }
                .error { color: red; }
            </style>
        </head>
        <body>
            <h2>KYC Admin Login</h2>
            <?php if (isset($error)) echo "<p class='error'>$error</p>"; ?>
            <form method="post">
                <input type="text" name="username" placeholder="Username" required>
                <input type="password" name="password" placeholder="Password" required>
                <button type="submit">Login</button>
            </form>
        </body>
        </html>
        <?php
        exit;
    }
}

// Database connection
$config = include '../config/database.php';
try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['dbname']};charset={$config['charset']}", 
        $config['username'], 
        $config['password'], 
        $config['options']
    );
} catch (PDOException $e) {
    die('Database connection failed: ' . $e->getMessage());
}

// Handle status updates
if (isset($_POST['update_status'])) {
    $id = $_POST['application_id'];
    $status = $_POST['status'];
    $reason = $_POST['reason'] ?? null;
    
    $stmt = $pdo->prepare("UPDATE kyc_applications SET status = ?, rejection_reason = ?, reviewed_by = 1, reviewed_at = NOW() WHERE id = ?");
    $stmt->execute([$status, $reason, $id]);
    
    echo "<script>alert('Status updated successfully'); window.location.reload();</script>";
}

// Fetch applications
$stmt = $pdo->query("SELECT * FROM kyc_application_summary ORDER BY created_at DESC");
$applications = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <title>KYC Applications Admin</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .status-pending { background-color: #fff3cd; }
        .status-approved { background-color: #d4edda; }
        .status-rejected { background-color: #f8d7da; }
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); }
        .modal-content { background: white; margin: 50px auto; padding: 20px; width: 80%; max-width: 600px; }
        button { padding: 5px 10px; margin: 2px; cursor: pointer; }
    </style>
</head>
<body>
    <h1>KYC Applications Management</h1>
    <p><a href="?logout=1">Logout</a></p>
    
    <?php if (isset($_GET['logout'])) { session_destroy(); header('Location: view_applications.php'); exit; } ?>
    
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Country</th>
                <th>Status</th>
                <th>Submitted</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($applications as $app): ?>
            <tr class="status-<?php echo $app['status']; ?>">
                <td><?php echo $app['id']; ?></td>
                <td><?php echo htmlspecialchars($app['first_name'] . ' ' . $app['last_name']); ?></td>
                <td><?php echo htmlspecialchars($app['email']); ?></td>
                <td><?php echo strtoupper($app['country']); ?></td>
                <td><?php echo ucfirst($app['status']); ?></td>
                <td><?php echo date('Y-m-d H:i', strtotime($app['created_at'])); ?></td>
                <td>
                    <button onclick="viewDetails(<?php echo $app['id']; ?>)">View</button>
                    <button onclick="updateStatus(<?php echo $app['id']; ?>)">Update Status</button>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Modal for viewing details -->
    <div id="detailsModal" class="modal">
        <div class="modal-content">
            <span onclick="closeModal()" style="float: right; cursor: pointer;">&times;</span>
            <div id="detailsContent"></div>
        </div>
    </div>

    <!-- Modal for updating status -->
    <div id="statusModal" class="modal">
        <div class="modal-content">
            <span onclick="closeModal()" style="float: right; cursor: pointer;">&times;</span>
            <h3>Update Application Status</h3>
            <form method="post">
                <input type="hidden" id="statusApplicationId" name="application_id">
                <label>Status:</label>
                <select name="status" required>
                    <option value="pending">Pending</option>
                    <option value="under_review">Under Review</option>
                    <option value="approved">Approved</option>
                    <option value="rejected">Rejected</option>
                    <option value="requires_documents">Requires Documents</option>
                </select>
                <br><br>
                <label>Reason (if rejecting):</label>
                <textarea name="reason" rows="3" cols="50"></textarea>
                <br><br>
                <button type="submit" name="update_status">Update Status</button>
                <button type="button" onclick="closeModal()">Cancel</button>
            </form>
        </div>
    </div>

    <script>
        function viewDetails(id) {
            // Fetch and display application details
            fetch(`get_application.php?id=${id}`)
                .then(response => response.text())
                .then(data => {
                    document.getElementById('detailsContent').innerHTML = data;
                    document.getElementById('detailsModal').style.display = 'block';
                });
        }

        function updateStatus(id) {
            document.getElementById('statusApplicationId').value = id;
            document.getElementById('statusModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('detailsModal').style.display = 'none';
            document.getElementById('statusModal').style.display = 'none';
        }
    </script>
</body>
</html>
